/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.eap.cloudsdk.client;

import com.tplink.eap.cloudsdk.DNSResolver;
import com.tplink.eap.cloudsdk.LogCenter;
import com.tplink.eap.cloudsdk.client.CloudResponse;
import com.tplink.eap.cloudsdk.client.ConnectionStatus;
import com.tplink.eap.cloudsdk.client.HelloCloud;
import com.tplink.eap.cloudsdk.client.HelloCloudDelegate;
import com.tplink.eap.cloudsdk.client.IPacketDispatch;
import com.tplink.eap.cloudsdk.client.Packet;
import com.tplink.eap.cloudsdk.client.Response;
import com.tplink.eap.cloudsdk.client.SSLClient;
import com.tplink.eap.cloudsdk.client.StopConnReason;
import com.tplink.eap.cloudsdk.util.FourTuple;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEFClient
implements IPacketDispatch {
    private static final Logger logger = LoggerFactory.getLogger(SEFClient.class);
    private final String domain = "n-deventry-smb.tplinkcloud.com";
    private final int port = 443;
    private List<InetAddress> addressList = new ArrayList<InetAddress>();
    private final int reconnectMaxTimes = 3;
    private final int firstReconnectTimeWaitMaxMs = 5000;
    private final int secondReconnectTimeWaitMaxMs = 10000;
    private final int requestTimeoutMs = 5000;
    private final int getResponseInterval = 500;
    private SSLClient sslClient;
    private final int minMsgId = 1;
    private final int maxMsgId = 65535;
    private volatile ConnectionStatus connStatus = ConnectionStatus.DISCONNECTED_NORMAL;
    private int msgId = 1;
    private HelloCloud helloCloud;
    private Map<Integer, CloudResponse> responseMap = new ConcurrentHashMap<Integer, CloudResponse>();
    private volatile boolean isSkipped = false;

    public SEFClient(HelloCloudDelegate helloCloudDelegate) {
        this.helloCloud = new HelloCloud(helloCloudDelegate, HelloCloud.ClientType.SEF_CLIENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Packet packet) throws UnsupportedEncodingException, Packet.InvalidMessageFormatException {
        JSONObject jsonData = packet.getJson();
        if (packet.checkPacket(jsonData).equals((Object)Packet.PacketType.RESPONSE)) {
            logger.debug("Cloud response is {}.", (Object)jsonData.toString());
            int id = jsonData.getInt(Response.KEY_ID);
            Map<Integer, CloudResponse> map = this.responseMap;
            synchronized (map) {
                if (this.responseMap.get(id).getDelagate() != null) {
                    this.responseMap.get(id).getDelagate().onResponse(jsonData);
                    this.responseMap.remove(id);
                } else {
                    this.responseMap.get(id).setResponse(jsonData);
                }
            }
        } else {
            logger.warn("Unhandled message.");
        }
    }

    public synchronized FourTuple<Boolean, String, Integer, Integer> autoConnect() throws InterruptedException {
        boolean connected = false;
        int reconnectTimes = 0;
        int reconnectWaitTimeMs = 0;
        this.setSkipped(false);
        while (reconnectTimes < 3 && !Thread.currentThread().isInterrupted()) {
            logger.debug("Connects SEF server {} times.", (Object)(reconnectTimes + 1));
            ++reconnectTimes;
            try {
                connected = this.connect(true);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                logger.info("Exception occurs when connecting SEF server:{}", (Object)e.toString());
                logger.debug(e.toString(), (Throwable)e);
                connected = false;
            }
            if (connected) {
                this.setConnStatus(ConnectionStatus.CONNECTED);
                connected = true;
                break;
            }
            if (this.helloCloud.getReconnectTime() > 0L) {
                this.setConnStatus(ConnectionStatus.DISCONNECTED_FORBIDDEN);
                connected = this.connectDuringWait(this.helloCloud.getReconnectTime() * 1000L);
                if (connected || this.isSkipped()) break;
                this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
                reconnectTimes = 0;
                reconnectWaitTimeMs = 0;
                continue;
            }
            this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
            if (reconnectTimes == 1) {
                this.clean();
                reconnectWaitTimeMs = 5000;
            } else if (reconnectTimes == 2) {
                this.clean();
                reconnectWaitTimeMs = 10000;
            }
            if (reconnectTimes < 3 && ((connected = this.connectDuringWait(reconnectWaitTimeMs)) || this.isSkipped())) break;
        }
        logger.info("The result of connection is {}, service host is {}, port is {}.", new Object[]{connected, this.helloCloud.getDomain(), this.helloCloud.getPort()});
        return new FourTuple<Boolean, String, Integer, Integer>(connected, this.helloCloud.getDomain(), this.helloCloud.getPort(), this.helloCloud.getValidTimeOnDevice());
    }

    public synchronized void close() {
        this.notifyAll();
        this.setSkipped(false);
        this.clean();
        this.setConnStatus(ConnectionStatus.DISCONNECTED_NORMAL);
    }

    public ConnectionStatus getConnStatus() {
        return this.connStatus;
    }

    private void setConnStatus(ConnectionStatus connStatus) {
        this.connStatus = connStatus;
    }

    public boolean isSkipped() {
        return this.isSkipped;
    }

    public void setSkipped(boolean isSkipped) {
        this.isSkipped = isSkipped;
    }

    private boolean connect(boolean timeoutRetry) throws IOException, InterruptedException, NoSuchAlgorithmException {
        JSONObject response;
        boolean connected = false;
        ConnectionStatus connStatus = this.getConnStatus();
        if (connStatus.equals((Object)ConnectionStatus.CONNECTED)) {
            return true;
        }
        this.setConnStatus(ConnectionStatus.CONNECTING);
        if (this.sslClient == null) {
            this.sslClient = new SSLClient(this.removeFirstAddress(), 443);
        } else {
            this.sslClient.updateClient(this.removeFirstAddress(), 443);
        }
        this.helloCloud.reset();
        this.sslClient.connect();
        this.recv();
        int retry = 0;
        do {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Interrupts the connection of SEF client.");
            }
            response = this.send(this.helloCloud.getRequest(this.generateMsgId()));
            this.helloCloud.onResponse(response);
            if (!timeoutRetry || response.getInt("error_code") != -20002 || ++retry >= 3) continue;
            this.wait(5000L);
        } while (!this.isSkipped() && timeoutRetry && response.getInt("error_code") == -20002 && retry < 3);
        if (response.getInt("error_code") == 0 && this.helloCloud.getIllegalType() == 0 && this.helloCloud.getStopConnect().equals((Object)StopConnReason.DEFAULT_NORMAL)) {
            connected = true;
        }
        return connected;
    }

    private void clean() {
        try {
            try {
                if (this.sslClient != null) {
                    this.sslClient.close();
                }
            }
            catch (IOException e) {
                logger.info(e.toString(), (Throwable)e);
                this.msgId = 1;
                this.responseMap.clear();
            }
        }
        finally {
            this.msgId = 1;
            this.responseMap.clear();
        }
    }

    private boolean connectDuringWait(long waitTimeMs) throws InterruptedException {
        boolean connected = false;
        long leftWaitTimeMs = waitTimeMs;
        long waitEndTimeMs = System.currentTimeMillis() + leftWaitTimeMs;
        do {
            this.clean();
            this.wait(leftWaitTimeMs);
            leftWaitTimeMs = waitEndTimeMs - System.currentTimeMillis();
            if (leftWaitTimeMs <= 0L) continue;
            try {
                ConnectionStatus status = this.getConnStatus();
                connected = this.connect(false);
                if (connected) break;
                this.clean();
                this.setConnStatus(status);
            }
            catch (IOException | NoSuchAlgorithmException e) {
                logger.info(e.toString(), (Throwable)e);
                connected = false;
            }
        } while (!this.isSkipped() && leftWaitTimeMs > 0L && !Thread.currentThread().isInterrupted());
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject send(JSONObject request) throws IOException, InterruptedException {
        JSONObject response = null;
        int id = 0;
        try {
            id = this.addResponseMap(request.has("id") ? request.getInt("id") : 0);
            request.put((Object)"id", (Object)id);
            if (logger.isDebugEnabled()) {
                if (LogCenter.getLogAll()) {
                    logger.debug("Device request is {}.", (Object)request.toString());
                } else {
                    logger.debug("Method of device request(id:{}) is {}.", (Object)request.optInt("id"), (Object)request.optString("method"));
                }
            }
            Packet pkt = new Packet();
            this.sslClient.send(pkt.pack(request));
            long timeBegin = System.currentTimeMillis();
            while (System.currentTimeMillis() - timeBegin < 5000L) {
                Map<Integer, CloudResponse> map = this.responseMap;
                synchronized (map) {
                    if (this.responseMap.get(id).getResponse() != null) {
                        response = this.responseMap.get(id).getResponse();
                        break;
                    }
                }
                Thread.sleep(500L);
            }
            if (response == null) {
                response = new JSONObject();
                response.put((Object)"error_code", (Object)-20002);
            }
        }
        finally {
            this.responseMap.remove(id);
            if (response == null) {
                response = new JSONObject();
                response.put((Object)"error_code", (Object)-10000);
            }
        }
        return response;
    }

    private void recv() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SEFClient.this.sslClient.recv(SEFClient.this);
                }
                catch (SocketException e) {
                    logger.debug(e.toString(), (Throwable)e);
                }
                catch (IOException e) {
                    logger.info(e.toString(), (Throwable)e);
                }
                logger.info("ssl recv thread is stopped.");
            }
        }).start();
    }

    private void buildAddressList() throws UnknownHostException {
        Collections.addAll(this.addressList, DNSResolver.getAddresses("n-deventry-smb.tplinkcloud.com"));
        Collections.shuffle(this.addressList);
    }

    private InetAddress removeFirstAddress() throws UnknownHostException {
        if (this.addressListIsEmpty()) {
            this.buildAddressList();
        }
        InetAddress address = this.addressList.remove(0);
        if (logger.isDebugEnabled()) {
            logger.debug("InetAddress of connected service server is {}.", (Object)address);
        }
        return address;
    }

    private boolean addressListIsEmpty() {
        return this.addressList.size() == 0;
    }

    private int generateMsgId() {
        if (this.msgId < 1 || this.msgId > 65535) {
            this.msgId = 1;
        }
        return this.msgId++;
    }

    private int addResponseMap(int msgId) {
        int id = msgId < 1 || msgId > 65535 ? this.generateMsgId() : msgId;
        this.responseMap.put(id, new CloudResponse(id));
        return id;
    }
}

